/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.block.craft.CookStep;
import cloud.lemonslice.teastory.block.craft.IStoveBlock;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.registry.ItemRegister;

public class SaucepanBlock
extends NormalHorizontalBlock {
    public static final EnumProperty<CookStep> STEP = EnumProperty.m_61587_((String)"step", CookStep.class);
    public static final BooleanProperty LID = BooleanProperty.m_61465_((String)"lid");
    private static final VoxelShape PAN_SHAPE;
    private static final VoxelShape LID_SHAPE;

    public SaucepanBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(STEP, (Comparable)((Object)CookStep.EMPTY))).m_61124_((Property)LID, (Comparable)Boolean.valueOf(true)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)LID) != false ? LID_SHAPE : PAN_SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{STEP, LID}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (stateIn.m_61143_(STEP) == CookStep.COOKED) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + rand.m_188500_() * 6.0 / 16.0;
            double d2 = (double)pos.m_123343_() + 0.5;
            double d4 = rand.m_188500_() * 0.6 - 0.3;
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123796_, false, d0 + d4, d1 + 0.5, d2 + d4, 0.0, 0.1, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            ItemStack held = player.m_21120_(handIn);
            if (((Boolean)state.m_61143_((Property)LID)).booleanValue()) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LID, (Comparable)Boolean.valueOf(false)));
                player.m_36356_(new ItemStack((ItemLike)ItemRegister.SAUCEPAN_LID.get()));
                return InteractionResult.SUCCESS;
            }
            if (state.m_61143_(STEP) == CookStep.COOKED) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(STEP, (Comparable)((Object)CookStep.EMPTY)));
                player.m_36356_(new ItemStack((ItemLike)ItemRegister.RICE_BALL.get(), 3));
                return InteractionResult.SUCCESS;
            }
            if (held.m_41720_() == ItemRegister.SAUCEPAN_LID.get()) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LID, (Comparable)Boolean.valueOf(true)));
                held.m_41774_(1);
                worldIn.m_6263_(null, (double)player.m_146903_(), (double)player.m_146904_() + 0.5, (double)player.m_146907_(), SoundEvents.f_12064_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (state.m_61143_(STEP) == CookStep.RAW && FluidUtil.getFluidContained((ItemStack)held).isPresent()) {
                FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)held).get();
                if (fluidStack.getFluid() == Fluids.f_76193_ && fluidStack.getAmount() >= 1000) {
                    if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)new FluidTank(1000))) {
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_(STEP, (Comparable)((Object)CookStep.WATER)));
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                return InteractionResult.FAIL;
            }
            if (state.m_61143_(STEP) == CookStep.EMPTY && held.m_41720_() == ItemRegister.WASHED_RICE.get() && held.m_41613_() >= 8) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(STEP, (Comparable)((Object)CookStep.RAW)));
                worldIn.m_6263_(null, (double)player.m_146903_(), (double)player.m_146904_() + 0.5, (double)player.m_146907_(), SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    held.m_41774_(8);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null && context.m_43722_().m_41784_().m_128441_("lid")) {
            state = (BlockState)state.m_61124_((Property)LID, (Comparable)Boolean.valueOf(context.m_43722_().m_41784_().m_128471_("lid")));
        }
        return state;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockState stove = worldIn.m_8055_(pos.m_7495_());
        if (IStoveBlock.isBurning(stove) && state.m_61143_(STEP) == CookStep.WATER) {
            int fuelPower = ((IStoveBlock)stove.m_60734_()).getFuelPower();
            if (((Boolean)state.m_61143_((Property)LID)).booleanValue()) {
                if (random.m_188503_(6 / fuelPower) == 0) {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_(STEP, (Comparable)((Object)CookStep.COOKED)));
                }
            } else if (random.m_188503_(24 / fuelPower) == 0) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(STEP, (Comparable)((Object)CookStep.COOKED)));
            }
        }
    }

    static {
        VoxelShape outer = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 1.0, 14.0, 12.0, 14.0);
        VoxelShape inner = VoxelShapeHelper.createVoxelShape(2.0, 1.0, 2.0, 12.0, 11.0, 12.0);
        LID_SHAPE = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 1.0, 14.0, 13.0, 14.0);
        PAN_SHAPE = Shapes.m_83113_((VoxelShape)outer, (VoxelShape)inner, (BooleanOp)BooleanOp.f_82687_);
    }
}

